/*
 * Local.java
 *
 * Created on 26 de mayo de 2008, 20:00
 */

package locals;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import situacio.*;
import entitats.*;
import contractes.*;
/**
 *
 * @author dai
 * @version
 */

public class Local extends org.apache.struts.action.ActionForm {
    
    private int idLocal; //int. Id del local
    private String adresa; //Adresa.
    private String codiLocal; // String. Codi identificatiu del local
    private String tipus; //String. Tipus del local
    private Float superficie; //Float. Superficie util del local
    private String caracteristiques; // String. Caracteristiques del local
    private String restriccions; //String. Restriccions del local
    private boolean actiu; //Boolean. Indica si el local esta donat d'alta
    private Propietari propietari; // Propietari. Propietari del local
    private Contracte contracte; //Contracte. Contracte que te el loca, pot no tenir contracte si no esta llogat
    private String error;
    private Float String;
    private Float volum;
    private String zona;
    private String caracteristiquesPolivalents;
    private Float preu;
    private int immoble; //sera del combobox del jsp, indicara el id del immoble a on s'afegeix un nou local.
    private String plantaPis;
    
    public Local()
    {
        
    }
    
    public Local(int idLocal, String adresa)
    {
        this.setIdLocal(idLocal);
        this.setAdresa(adresa);
    }
    
    public int getIdLocal() {
        return idLocal;
    }
    
    public void setIdLocal(int idLocal) {
        this.idLocal = idLocal;
    }
    
    public String getAdresa() {
        return adresa;
    }
    
    public void setAdresa(String adresa) {
        this.adresa = adresa;
    }
    
    public String getCodiLocal() {
        return codiLocal;
    }
    
    public void setCodiLocal(String codiLocal) {
        this.codiLocal = codiLocal;
    }
    
    public String getTipus() {
        return tipus;
    }
    
    public void setTipus(String tipus) {
        this.tipus = tipus;
    }
    
    public Float getSuperficie() {
        return superficie;
    }
    
    public void setSuperficie(Float superficie) {
        this.superficie = superficie;
    }
    
    public String getCaracteristiques() {
        return caracteristiques;
    }
    
    public void setCaracteristiques(String caracteristiques) {
        this.caracteristiques = caracteristiques;
    }
    
    public String getRestriccions() {
        return restriccions;
    }
    
    public void setRestriccions(String restriccions) {
        this.restriccions = restriccions;
    }
    
    public boolean isActiu() {
        return actiu;
    }
    
    public void setActiu(boolean actiu) {
        this.actiu = actiu;
    }
    
    public Propietari getPropietari() {
        return propietari;
    }
    
    public void setPropietari(Propietari propietari) {
        this.propietari = propietari;
    }
    
    public Contracte getContracte() {
        return contracte;
    }
    
    public void setContracte(Contracte contracte) {
        this.contracte = contracte;
    }
    
    public String getError() {
        return error;
    }
    
    public void setError(String error) {
        this.error = error;
    }
    
    public Float getString() {
        return String;
    }
    
    public void setString(Float String) {
        this.String = String;
    }
    
    public Float getVolum() {
        return volum;
    }
    
    public void setVolum(Float volum) {
        this.volum = volum;
    }
    
    public String getZona() {
        return zona;
    }
    
    public void setZona(String zona) {
        this.zona = zona;
    }
    
    public String getCaracteristiquesPolivalents() {
        return caracteristiquesPolivalents;
    }
    
    public void setCaracteristiquesPolivalents(String caracteristiquesPolivalents) {
        this.caracteristiquesPolivalents = caracteristiquesPolivalents;
    }
    
    public Float getPreu() {
        return preu;
    }
    
    public void setPreu(Float preu) {
        this.preu = preu;
    }
    
    /* opcionals
     *superficie
     *preu
     *caracteristiques
     *restriccions
     *volum
     *caract. pol.
     */
    public boolean comprovaDadesFormulari() {
        if (!getAdresa().isEmpty() || getSuperficie().equals(null)) {
            this.setError("Hi han valors obligatoris buits");
            return false;
        } else{
            return true;
        }
    }
    
    public int getImmoble() {
        return immoble;
    }
    
    public void setImmoble(int immoble) {
        this.immoble = immoble;
    }
    
    public String getPlantaPis() {
        return plantaPis;
    }
    
    public void setPlantaPis(String plantaPis) {
        this.plantaPis = plantaPis;
    }
    
    public String creaCodi(int idLocal) {
        String codi = "";
        codi += this.getZona();
        if (this.getTipus().equals("botiga_magatzem"))
            codi+="b";
        else if (this.getTipus().equals("polivalent"))
            codi+="p;";
        else if (this.getTipus().equals("oficina"))
            codi+="o";
        else if (this.getTipus().equals("immoble"))
            codi+="i";
        codi +=idLocal;
        return codi;
                
        
                
                
    }
    
    
}
